#!/usr/bin/env python
#-*- coding:utf-8 -*-

'''
Created on May 12, 2011

@author: kristinr08
'''

import time
import serial
import sys
import sqlite3

conn = sqlite3.connect('heatdata.db')
c = conn.cursor()

c.execute("select * from RFID")
tag = raw_input('Write number of tag: ')
for row in c:
    if int(tag) == row[0]:
        tagid = row[9]
        print tagid

class RFIDReader:
    """
    We do some intelligent serial things here, optimized for the RFID reader
    """
    errors = ["Invalid error.",
              "Invalid command.",
              "Invalid argument.",
              "Missing argument or incorrect number of arguments.",
              "Operation failed because no tag was detected.",
              "Operation failed because more than one tag detected.",
              "Tag detected but operation did not complete.",
              "Lock failed (only during L command).",
              "Operation failed: tag locked.",
              "Operation failed: insufficient power.",
              "Operation failed: incorrect access password."                            
              ]

    
    
    def __init__(self, port="/dev/ttyUSB0", baudrate=115200):
        """constructor, fire up the connection"""
        self.serial = serial.Serial(port, baudrate = baudrate, timeout=1)
        
        # enter console->serial loop

# D causes only one read to be sent per tag
    def slow_write(self, data, delay=0.01, addCR=True):
        """
        Slower version of serial write that allows time for the reader to parse
        """
        for letter in data:
            retcode = self.serial.write(letter)
            time.sleep(delay)
        addCR and self.serial.write("\r")
        return retcode

    def send_confirm(self, command, desc, failonerror = False):
        resp = ""
        # sometimes there is old garbled commands
        # if things fail, try again
        while(resp == "" or resp[0] != command[0]):
            # IMPORTANT: The reader controller is not fast enough to run at 115200
            # we must send our characters a little slower.  Remember that the old one
            # expected to go at 9600
            self.slow_write(command)

            #sys.stdout.write(repr(self.serial.read(1)))
            resp = self.serial.readline().rstrip("\n").rstrip("\r")

            #resp = ser.readline()
            print "%s: %s = '%s'" % (desc, ByteToHex(resp), resp)
        return resp
    

def ByteToHex( byteStr ):
    """
    Convert a byte string to it's hex string representation e.g. for output.
    """
    
    # Uses list comprehension which is a fractionally faster implementation than
    # the alternative, more readable, implementation below
    #   
    #    hex = []
    #    for aChar in byteStr:
    #        hex.append( "%02X " % ord( aChar ) )
    #
    #    return ''.join( hex ).strip()        

    return ''.join( [ "%02X " % ord( x ) for x in byteStr ] ).strip()


if __name__ == '__main__':
    print "CR is %s, LF is %s" % (ByteToHex("\r"), ByteToHex("\n"))
    st = RFIDReader(port="/dev/ttyUSB0")
    st.send_confirm("E", "echo/NOECHO")
    st.send_confirm(",", "ReadingSpeed")
    st.send_confirm("D", "datastream/NO DATA STREAMING")
    st.send_confirm("T.", "target")
    st.send_confirm("W"+str(tagid), "write")